/*
 * Decompiled with CFR 0.152.
 */
package JUpload.clipboard;

import JUpload.swingVersion.JUpload;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import sun.awt.datatransfer.ClipboardTransferable;

public class ClipboardUtil {
    public static BufferedImage getClipboardImage() {
        Toolkit tk;
        Clipboard cp;
        BufferedImage image;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((image = ClipboardUtil.checkClipboard(cp = (tk = Toolkit.getDefaultToolkit()).getSystemClipboard())) == null) {
            image = ClipboardUtil.checkClipboard(tk.getSystemSelection());
        }
        return image;
    }

    private static BufferedImage checkClipboard(Clipboard cp) {
        if (cp == null) {
            return null;
        }
        Transferable o = cp.getContents(JUpload.getInstance());
        if (o instanceof ClipboardTransferable) {
            ClipboardTransferable trans = (ClipboardTransferable)o;
            DataFlavor[] dataFlavors = trans.getTransferDataFlavors();
            for (int i = 0; i < dataFlavors.length; ++i) {
                DataFlavor flavor = dataFlavors[i];
                Object transObject = null;
                try {
                    transObject = trans.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (transObject == null) {
                    return null;
                }
                if (!flavor.getPrimaryType().equals("image") || !(transObject instanceof BufferedImage)) continue;
                BufferedImage bi = (BufferedImage)transObject;
                return bi;
            }
        }
        return null;
    }

    public static List getClipboardFiles() {
        Toolkit tk;
        Clipboard cp;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((cp = (tk = Toolkit.getDefaultToolkit()).getSystemClipboard()) == null) {
            return null;
        }
        Transferable o = cp.getContents(JUpload.getInstance());
        if (o instanceof ClipboardTransferable) {
            ClipboardTransferable trans = (ClipboardTransferable)o;
            DataFlavor[] dataFlavors = trans.getTransferDataFlavors();
            for (int i = 0; i < dataFlavors.length; ++i) {
                DataFlavor flavor = dataFlavors[i];
                Object transObject = null;
                try {
                    transObject = trans.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (transObject == null) {
                    return null;
                }
                if (!(transObject instanceof List)) continue;
                return (List)transObject;
            }
        }
        return null;
    }
}

