/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.Messages;
import JUpload.http.AsyncInputStream;
import JUpload.http.HTTPRequest;
import JUpload.http.HttpResponse;
import JUpload.network.HostConfiguration;
import JUpload.network.HttpClient;
import JUpload.network.HttpConnection;
import JUpload.network.HttpConnectionManager;
import JUpload.plugin.PluginManager;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import JUpload.utilities.ProxyConfig;
import JUpload.utilities.Utils;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public abstract class AbstractHTTPRequest
implements HTTPRequest {
    private static final Logger LOG = Logger.getLogger((class$JUpload$http$AbstractHTTPRequest == null ? (class$JUpload$http$AbstractHTTPRequest = AbstractHTTPRequest.class$("JUpload.http.AbstractHTTPRequest")) : class$JUpload$http$AbstractHTTPRequest).getName());
    protected static final String M_NewLine = "\r\n";
    protected JUpload parent = JUpload.getInstance();
    private String response;
    protected boolean standalone;
    protected URL actionURL;
    private int maxRetries;
    private InputStream httpIn;
    private OutputStream httpOut;
    private PipedInputStream pin;
    private HttpResponse httpResponse;
    static /* synthetic */ Class class$JUpload$http$AbstractHTTPRequest;

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    private String getBodyFromResponse2(String t_response) {
        String doublenewline = "\r\n\r\n";
        int position = t_response.indexOf(doublenewline);
        String body = t_response.substring(position + doublenewline.length());
        return body;
    }

    private boolean isChunkField2(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ": ");
        String strFieldname = "";
        String strMethod = "";
        if (tokenizer.hasMoreTokens()) {
            strFieldname = tokenizer.nextToken();
        }
        if (!strFieldname.equalsIgnoreCase("transfer-encoding")) {
            return false;
        }
        if (tokenizer.hasMoreTokens()) {
            strMethod = tokenizer.nextToken();
        }
        return strMethod.equalsIgnoreCase("chunked");
    }

    private boolean checkRealTimeResponse2() {
        if (this.getInputStream() == null) {
            LOG.warning("InputStream is null");
            return false;
        }
        char[] buffer = new char[8192];
        String line = "";
        InputStreamReader reader = new InputStreamReader(this.getInputStream());
        BufferedReader br = new BufferedReader(reader);
        boolean chunked = false;
        boolean infoResponse = false;
        long content_length = -1L;
        do {
            infoResponse = false;
            do {
                try {
                    line = br.readLine();
                    if (null == line) continue;
                    if (line.startsWith("HTTP/1.0 100")) {
                        infoResponse = true;
                    }
                    if (line.startsWith("HTTP/1.1 100")) {
                        infoResponse = true;
                    }
                    if (line.toLowerCase().startsWith("content-length")) {
                        String number = line.substring(16).trim();
                        content_length = Integer.parseInt(number);
                    }
                    if (line == null || !this.isChunkField2(line)) continue;
                    chunked = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (line != null && !line.equalsIgnoreCase(""));
        } while (infoResponse);
        String a_response = new String();
        if (!chunked) {
            try {
                int c;
                while ((br.ready() || (long)a_response.length() < content_length) && (c = br.read(buffer)) != -1) {
                    String strBuf = new String(buffer, 0, c);
                    LOG.finest("Received buffer: [" + strBuf + "]");
                    a_response = a_response + strBuf;
                    this.parent.serverResponse.addResponse(a_response);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                int dataLength = 0;
                do {
                    line = br.readLine();
                    LOG.finest("Received line: [" + line + "]");
                    if (line.equalsIgnoreCase("")) continue;
                    dataLength = Utils.getSizeFromHex(line);
                    if (dataLength != 0) {
                        buffer = new char[dataLength];
                        br.read(buffer);
                        a_response = a_response + new String(buffer);
                        this.parent.serverResponse.addResponse(a_response);
                        continue;
                    }
                    LOG.finest("End-Of-Chunk indication received");
                } while (dataLength != 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setResponse2(a_response);
        LOG.finest("Received response: [" + a_response + "]");
        return true;
    }

    protected void setResponse2(String t_response) {
        this.response = t_response;
    }

    protected String getResponse2() {
        if (this.response == null) {
            this.receiveResponse2();
            return this.response;
        }
        return this.response;
    }

    private boolean checkSuccess2(String t_response) {
        StringTokenizer tok = new StringTokenizer(t_response);
        if (tok.countTokens() < 3) {
            return false;
        }
        String strHTTPVersion = tok.nextToken();
        LOG.finer("Server Response HTTP Version:" + strHTTPVersion);
        String strStatusCode = tok.nextToken();
        String strReasonPhrase = tok.nextToken(M_NewLine);
        int iStatusCode = 0;
        try {
            iStatusCode = Integer.parseInt(strStatusCode);
        }
        catch (Exception e) {
            LOG.warning("Error parsing status code from :" + strStatusCode);
            LOG.throwing((class$JUpload$http$AbstractHTTPRequest == null ? (class$JUpload$http$AbstractHTTPRequest = AbstractHTTPRequest.class$("JUpload.http.AbstractHTTPRequest")) : class$JUpload$http$AbstractHTTPRequest).getName(), "checkSuccess2", e);
        }
        if (Configurator.getShowServerResponse()) {
            LOG.info("Opening dialog showing server response");
            String body = this.getBodyFromResponse2(this.response);
            JEditorPane content = new JEditorPane("text/html", body);
            content.setPreferredSize(new Dimension(300, 200));
            content.setMaximumSize(new Dimension(300, 200));
            JScrollPane scroller = new JScrollPane(content);
            scroller.setPreferredSize(new Dimension(300, 200));
            scroller.setMaximumSize(new Dimension(300, 200));
            JOptionPane.showMessageDialog(this.parent, scroller, Messages.getString("HTTPPostRequest.78"), 1);
            return iStatusCode == 200;
        }
        if (iStatusCode >= 500) {
            this.showErrorMessage(strStatusCode + Messages.getString("HTTPPostRequest.79") + Messages.getString("HTTPPostRequest.80") + strReasonPhrase);
            return false;
        }
        if (iStatusCode >= 400) {
            this.showErrorMessage(strStatusCode + Messages.getString("HTTPPostRequest.81") + Messages.getString("HTTPPostRequest.82") + strReasonPhrase);
            return false;
        }
        if (iStatusCode >= 300) {
            this.showErrorMessage(strStatusCode + Messages.getString("HTTPPostRequest.83") + Messages.getString("HTTPPostRequest.84") + strReasonPhrase);
            return false;
        }
        if (iStatusCode == 200 && Configurator.getShowSuccessDialog()) {
            JOptionPane.showMessageDialog(this.parent, Configurator.getSuccessDialogMessage(), Configurator.getSuccessDialogTitle(), 1);
        }
        if (iStatusCode >= 100 && iStatusCode < 200) {
            this.showErrorMessage(strStatusCode + Messages.getString("HTTPPostRequest.85") + Messages.getString("HTTPPostRequest.86") + strReasonPhrase);
            return false;
        }
        return true;
    }

    protected boolean receiveCheckResponse2() {
        if (null != this.getInputStream()) {
            if (Configurator.getRealTimeResponse()) {
                return this.checkRealTimeResponse2();
            }
            if (Configurator.getCheckResponse()) {
                LOG.info("Checking response");
                this.response = this.receiveResponse2();
                return this.checkSuccess2(this.response);
            }
        }
        LOG.info("Response checking is disabled");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private String receiveChunkedResponse2(BufferedReader br) {
        a_response = "";
        line = "";
        try {
            dataLength = -1;
            block2: while (true) {
                if ((line = br.readLine()).equalsIgnoreCase("") || (dataLength = Utils.getSizeFromHex(line)) < 0) {
                    continue;
                }
                if (dataLength != 0) {
                    buffer = new char[dataLength];
                    amount = 0;
                    total = 0;
                    rest = dataLength;
                    while (true) {
                        if (rest > 0) ** break;
                        continue block2;
                        amount = br.read(buffer, 0, rest);
                        rest = dataLength - (total += amount);
                        strChunk = new String(buffer, 0, amount);
                        a_response = a_response + strChunk;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return a_response;
    }

    private String receiveResponse2() {
        String line = "";
        InputStreamReader reader = new InputStreamReader(this.getInputStream());
        BufferedReader br = new BufferedReader(reader);
        boolean chunked = false;
        try {
            line = br.readLine();
            if (line.startsWith("HTTP/1.1 100") || line.startsWith("HTTP/1.0 100")) {
                do {
                    if (line == null) continue;
                    line = br.readLine();
                } while (!line.equalsIgnoreCase(""));
            } else {
                this.response = this.response + line + M_NewLine;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        do {
            try {
                line = br.readLine();
                if (line == null) continue;
                this.response = this.response + line + M_NewLine;
                if (!this.isChunkField2(line)) continue;
                chunked = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (!line.equalsIgnoreCase(""));
        if (!chunked) {
            LOG.info("Receiving not-chunked response");
            do {
                try {
                    line = br.readLine();
                    if (line == null) continue;
                    this.response = this.response + line + M_NewLine;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (line != null);
        } else {
            this.response = this.response + this.receiveChunkedResponse2(br);
        }
        this.setResponse2(this.getBodyFromResponse2(this.response));
        return this.response;
    }

    protected void showErrorMessage(String string) {
        if (!this.standalone) {
            JOptionPane.showMessageDialog(this.parent, string, Messages.getString("HTTPPostRequest.195"), 0);
        }
    }

    protected boolean createHttpConnection() {
        HttpClient client = new HttpClient();
        client.setConnectionTimeout(5000);
        HttpConnectionManager hcm = client.getHttpConnectionManager();
        HostConfiguration hconf = client.getHostConfiguration();
        hconf.setHost(this.actionURL.getHost(), this.actionURL.getPort(), this.actionURL.getProtocol());
        if (ProxyConfig.useProxy) {
            LOG.info("Using proxy settings");
            LOG.info("Proxy Hostname:" + ProxyConfig.proxyHostname);
            LOG.info("Proxy Port:" + ProxyConfig.proxyPort);
            hconf.setProxy(ProxyConfig.proxyHostname, Integer.parseInt(ProxyConfig.proxyPort));
        }
        HttpConnection hconn = hcm.getConnection(hconf);
        try {
            hconn.open();
        }
        catch (ConnectException e5) {
            if (!this.standalone) {
                JOptionPane.showMessageDialog(null, "Could not connect to server " + hconn.getHost(), "Could not connect", 0);
            }
            return false;
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        this.httpOut = null;
        this.httpIn = null;
        try {
            this.httpOut = hconn.getRequestOutputStream();
            this.httpOut = PluginManager.getInstance().hookOutputStream(this.httpOut);
            this.httpIn = hconn.getResponseInputStream();
            this.httpIn = PluginManager.getInstance().hookInputStream(this.httpIn);
        }
        catch (IllegalStateException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    protected void createStreams() {
        LOG.log(Level.FINER, "Creating transport streams");
        this.httpResponse = new HttpResponse();
        this.pin = new PipedInputStream();
        try {
            PipedOutputStream pos = new PipedOutputStream(this.pin);
            AsyncInputStream runnable = new AsyncInputStream(this.httpIn, pos);
            Thread thread = new Thread(runnable);
            thread.setName("Socket Reader");
            thread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OutputStream getOutputStream() {
        return this.httpOut;
    }

    public InputStream getInputStream() {
        return this.pin;
    }

    public HttpResponse getResponse() {
        this.httpResponse.parse(this.pin);
        return this.httpResponse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

