/*
 * Decompiled with CFR 0.152.
 */
package JUpload.imaging;

import JUpload.Messages;
import JUpload.gui.UploadStatus;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import JUpload.utilities.Utils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class ImageingUtilities {
    static /* synthetic */ Class class$JUpload$imaging$ImageingUtilities;

    public static void resizeWithMetadata(MyFile fileIN) {
        String suffix = Utils.getExtension(fileIN);
        if (suffix == null) {
            return;
        }
        Iterator<ImageReader> iterReader = ImageIO.getImageReadersBySuffix(suffix);
        Iterator<ImageWriter> iterWriter = ImageIO.getImageWritersByFormatName("jpg");
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(fileIN);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
            if (!iterReader.hasNext()) {
                System.err.println("No Image Reader for " + suffix);
                return;
            }
            ImageReader reader = iterReader.next();
            reader.setInput(iis);
            IIOMetadata metadata = reader.getStreamMetadata();
            BufferedImage src = reader.read(0);
            String alg = Configurator.getResizeInterpolationAlgorithm().toLowerCase();
            RenderingHints hints = new RenderingHints(new HashMap());
            if (alg.equals("bilinear")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (alg.equals("bicubic")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else if (alg.equals("nearest")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            double xscale = 1.0;
            double yscale = 1.0;
            double scale = 1.0;
            int maxWidth = Configurator.getResizeImageMaxWidth();
            int maxHeight = Configurator.getResizeImageMaxHeight();
            int currentWidth = src.getWidth();
            int currentHeight = src.getHeight();
            if (currentWidth > maxWidth) {
                xscale = (double)maxWidth / (double)currentWidth;
            }
            if (currentHeight > maxHeight) {
                yscale = (double)maxHeight / (double)currentHeight;
            }
            scale = xscale < yscale ? xscale : yscale;
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), hints);
            Debug.println(class$JUpload$imaging$ImageingUtilities == null ? (class$JUpload$imaging$ImageingUtilities = ImageingUtilities.class$("JUpload.imaging.ImageingUtilities")) : class$JUpload$imaging$ImageingUtilities, "Affine transform with metadata, scale factor is " + scale);
            BufferedImage dst = op.filter(src, null);
            ImageWriter writer = iterWriter.next();
            writer.setOutput(ios);
            writer.write(new IIOImage(dst, null, metadata));
            fileIN.setVirtualData(baos.toByteArray());
            fileIN.setVirtual(true);
            String filename = fileIN.getRelativeFilename();
            int pos = filename.lastIndexOf(46);
            filename = filename.substring(0, pos);
            fileIN.setVirtualRelativePathname(filename + ".jpg");
            writer.dispose();
            reader.dispose();
        }
        catch (IOException e1) {
            Debug.println(class$JUpload$imaging$ImageingUtilities == null ? (class$JUpload$imaging$ImageingUtilities = ImageingUtilities.class$("JUpload.imaging.ImageingUtilities")) : class$JUpload$imaging$ImageingUtilities, "Error while resizing: " + e1.getMessage());
        }
    }

    public static void convertImage(MyFile newFile, UploadStatus myStatus) throws IOException {
        BufferedImage bi;
        String format = Configurator.getConvertImagesToFormat().toLowerCase();
        if (format.equals("")) {
            return;
        }
        if (myStatus != null) {
            myStatus.setFilename(Messages.getString("ImageConverter.Converting", newFile.getName()));
            myStatus.setProgressbarVisible(true);
            myStatus.setValue(1L, 6L);
        }
        InputStream input = null;
        input = newFile.isVirtual() ? new ByteArrayInputStream(newFile.getVirtualData()) : new FileInputStream(newFile);
        if (input == null) {
            return;
        }
        try {
            bi = ImageIO.read(input);
        }
        catch (NoClassDefFoundError error) {
            System.err.println("Java 1.3 does not support extended image processing.");
            return;
        }
        if (bi == null) {
            Debug.println(class$JUpload$imaging$ImageingUtilities == null ? (class$JUpload$imaging$ImageingUtilities = ImageingUtilities.class$("JUpload.imaging.ImageingUtilities")) : class$JUpload$imaging$ImageingUtilities, "Could not read image format from " + newFile);
            return;
        }
        float maxWidth = Configurator.getResizeImageMaxWidth();
        float maxHeight = Configurator.getResizeImageMaxHeight();
        float oldWidth = bi.getWidth();
        float oldHeight = bi.getHeight();
        float ratio = oldWidth / oldHeight;
        float newWidth = oldWidth;
        float newHeight = oldHeight;
        if (maxWidth > 0.0f && newWidth > maxWidth) {
            newWidth = maxWidth;
            newHeight = newWidth / ratio;
        }
        if (maxHeight > 0.0f && newHeight > maxHeight) {
            newHeight = maxHeight;
            newWidth = newHeight * ratio;
        }
        int iWidth = (int)newWidth;
        int iHeight = (int)newHeight;
        Debug.println(class$JUpload$imaging$ImageingUtilities == null ? (class$JUpload$imaging$ImageingUtilities = ImageingUtilities.class$("JUpload.imaging.ImageingUtilities")) : class$JUpload$imaging$ImageingUtilities, "Scaling " + oldWidth + "x" + oldHeight + " to " + newWidth + "x" + newHeight);
        BufferedImage scaledImg = new BufferedImage(iWidth, iHeight, 1);
        if (Configurator.getImprovedShrinking()) {
            if (myStatus != null) {
                myStatus.setValue(2L, 6L);
            }
            ImageIcon img = new ImageIcon(bi);
            Image shrinked = img.getImage().getScaledInstance(iWidth, iHeight, 4);
            scaledImg.getGraphics().drawImage(shrinked, 0, 0, iWidth, iHeight, null);
            if (myStatus != null) {
                myStatus.setValue(3L, 6L);
            }
        } else {
            if (myStatus != null) {
                myStatus.setValue(2L, 6L);
            }
            Graphics2D gScaledImg = scaledImg.createGraphics();
            HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
            hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            String alg = Configurator.getResizeInterpolationAlgorithm().toLowerCase();
            if (alg.equals("bilinear")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (alg.equals("bicubic")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else if (alg.equals("nearest")) {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            gScaledImg.addRenderingHints(hints);
            gScaledImg.drawImage(bi, 0, 0, iWidth, iHeight, null);
            if (myStatus != null) {
                myStatus.setValue(3L, 6L);
            }
            gScaledImg.dispose();
            gScaledImg = null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (myStatus != null) {
            myStatus.setValue(4L, 6L);
        }
        boolean ok = ImageIO.write((RenderedImage)scaledImg, format, baos);
        if (myStatus != null) {
            myStatus.setValue(5L, 6L);
        }
        if (!ok) {
            Debug.println(class$JUpload$imaging$ImageingUtilities == null ? (class$JUpload$imaging$ImageingUtilities = ImageingUtilities.class$("JUpload.imaging.ImageingUtilities")) : class$JUpload$imaging$ImageingUtilities, "Could not convert into image format [" + format + "]");
            return;
        }
        newFile.setVirtualData(baos.toByteArray());
        newFile.setVirtual(true);
        String filename = newFile.getVirtualRelativePathname();
        int pos = filename.lastIndexOf(46);
        filename = filename.substring(0, pos);
        newFile.setVirtualRelativePathname(filename + "." + format);
        scaledImg = null;
        baos = null;
        bi = null;
        if (myStatus != null) {
            myStatus.setValue(6L, 6L);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

