/*
 * Decompiled with CFR 0.152.
 */
package JUpload.queuefilter;

import JUpload.queuefilter.ExpressionParser;
import JUpload.queuefilter.IQueueFilter;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public class ImageDimensionFilter
implements IQueueFilter {
    public boolean beforeQueueing(MyFile t_file) {
        if (t_file == null) {
            return true;
        }
        Dimension currentDimension = this.getDimensionFromImage(t_file);
        MyFile myFile = t_file;
        if (myFile.isVirtual()) {
            ImageIcon icon = new ImageIcon(myFile.getVirtualData());
            currentDimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        Debug.println(this, "Image is " + currentDimension);
        ExpressionParser parser = new ExpressionParser();
        parser.setVariable("width", currentDimension.width);
        parser.setVariable("height", currentDimension.height);
        String expression = Configurator.getDimensionFilter();
        if (expression.equals("")) {
            return true;
        }
        return parser.parse(expression);
    }

    private Dimension getDimensionFromImage(MyFile t_file) {
        ImageIcon icon = new ImageIcon(t_file.getAbsolutePath());
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }
}

