/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.Messages;
import JUpload.filefilter.CustomFileFilter;
import JUpload.filefilter.ImageFileFilter;
import JUpload.filefilter.RegexFileFilter;
import JUpload.gui.ImagePreviewAccessory;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.SystemFileView;
import JUpload.swingVersion.WalkerThread;
import JUpload.utilities.Configurator;
import JUpload.utilities.MyFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class myAddListener
implements ActionListener {
    private static final Logger LOG = Logger.getLogger((class$JUpload$swingVersion$myAddListener == null ? (class$JUpload$swingVersion$myAddListener = myAddListener.class$("JUpload.swingVersion.myAddListener")) : class$JUpload$swingVersion$myAddListener).getName());
    JUpload parent;
    JFileChooser jfc;
    WalkerThread walkerThread;
    static /* synthetic */ Class class$JUpload$swingVersion$myAddListener;

    myAddListener(JUpload t_parent) {
        this.parent = t_parent;
        this.walkerThread = WalkerThread.getInstance();
        if (null == this.jfc) {
            LOG.info("Creating file system view");
            FileSystemView fsv = FileSystemView.getFileSystemView();
            this.jfc = new JFileChooser(fsv);
            this.jfc.setFileView(new SystemFileView());
        }
        this.walkerThread.setJFC(this.jfc);
        try {
            this.jfc.setMultiSelectionEnabled(true);
        }
        catch (NoSuchMethodError nsme) {
            LOG.warning("Could not enable multiselection for file chooser");
        }
        if (Configurator.getPreventRecursion()) {
            this.jfc.setFileSelectionMode(0);
        } else {
            this.jfc.setFileSelectionMode(2);
        }
        if (Configurator.getImageFileFilter()) {
            ImageFileFilter iff = new ImageFileFilter();
            this.jfc.addChoosableFileFilter(iff);
        }
        if (Configurator.getCustomFileFilter()) {
            CustomFileFilter cff = new CustomFileFilter();
            this.jfc.addChoosableFileFilter(cff);
        }
        if (!Configurator.getRegexFileFilter().equals("")) {
            RegexFileFilter rff = new RegexFileFilter();
            this.jfc.addChoosableFileFilter(rff);
        }
        if (Configurator.getHideShowAll()) {
            this.jfc.setAcceptAllFileFilterUsed(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        LOG.info("Performing Add action");
        try {
            if (!Configurator.getDefaultAddDirectory().equalsIgnoreCase("")) {
                MyFile defDir = new MyFile(Configurator.getDefaultAddDirectory());
                this.jfc.setCurrentDirectory(defDir);
            }
            if (Configurator.getPreferences().getWorkingDirectory() != null) {
                MyFile workingDir = new MyFile(Configurator.getPreferences().getWorkingDirectory());
                this.jfc.setCurrentDirectory(workingDir);
            }
            if (Configurator.getPreferences().getLastFile() != null) {
                this.jfc.setSelectedFile(Configurator.getPreferences().getLastFile());
            }
            if (Configurator.getShowPicturePreview()) {
                try {
                    this.jfc.setAccessory(new ImagePreviewAccessory(this.jfc));
                }
                catch (Exception e5) {
                    LOG.warning("Could not install image preview in file chooser");
                }
            }
            LOG.info("Opening file chooser");
            int rVal = this.jfc.showDialog(this.parent, Configurator.getAddWindowTitle());
            LOG.info("Returned from file chooser");
            File currentDir = this.jfc.getCurrentDirectory();
            Configurator.getPreferences().setWorkingDirectory(currentDir);
            Configurator.getPreferences().store();
            this.walkerThread.setCurrentDirectory(currentDir);
            if (rVal == 0) {
                File lastFile = this.jfc.getSelectedFile();
                Configurator.getPreferences().setLastFile(lastFile);
                Runnable run = new Runnable(){

                    public void run() {
                        myAddListener.this.walkerThread.addFiles(JUpload.convertToMyfiles(myAddListener.this.jfc.getSelectedFiles()));
                    }
                };
                Thread addThread = new Thread(run);
                addThread.setPriority(1);
                addThread.start();
            }
            if (rVal == 1) {
                LOG.info("User cancelled file chooser dialog.");
            }
        }
        catch (AccessControlException ace) {
            JOptionPane.showMessageDialog(this.parent, Messages.getString("myAddListener.13"), Messages.getString("myAddListener.14"), 0);
            ace.printStackTrace();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

