/*
 * Decompiled with CFR 0.152.
 */
import JUpload.utilities.MyFile;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JTable;

public class myMouseListener
extends MouseAdapter {
    SimpleFileChooser chooser;

    public myMouseListener(SimpleFileChooser t_chooser) {
        this.chooser = t_chooser;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            switch (this.chooser.explorer.getMode()) {
                case 1: {
                    this.doubleClickList(e);
                    break;
                }
                case 3: {
                    this.doubleClickThumbnail(e);
                    break;
                }
                case 2: {
                    this.doubleClickDetailed(e);
                }
            }
        }
    }

    private void doubleClickDetailed(MouseEvent e) {
        if (e.getSource() instanceof JTable) {
            JTable source = (JTable)e.getSource();
            int index = source.getSelectedRow();
            String filename = (String)source.getValueAt(index, 0);
            DetailedTableModel dtm = (DetailedTableModel)source.getModel();
            File file = dtm.getFile(filename);
            if (file == null) {
                return;
            }
            if (file.isDirectory()) {
                this.chooser.gotoFolder(file);
            }
            if (file.isFile()) {
                this.chooser.sendFileToJUpload(file);
            }
        }
    }

    private void doubleClickList(MouseEvent e) {
        int index = this.chooser.explorer.getViewList().locationToIndex(e.getPoint());
        MyFile file = (MyFile)this.chooser.explorer.getViewList().getModel().getElementAt(index);
        if (file.isDirectory()) {
            this.chooser.gotoFolder(file);
        }
        if (file.isFile()) {
            this.chooser.sendFileToJUpload(file);
        }
    }

    private void doubleClickThumbnail(MouseEvent e) {
        int index = this.chooser.explorer.getViewThumbnail().locationToIndex(e.getPoint());
        MyFile file = (MyFile)this.chooser.explorer.getViewThumbnail().getModel().getElementAt(index);
        if (file.isDirectory()) {
            this.chooser.gotoFolder(file);
        }
        if (file.isFile()) {
            this.chooser.sendFileToJUpload(file);
        }
    }
}

