<?php

if(!function_exists('tagpig_show_notices')) {
  function tagpig_show_notices() {
    $result = false;

    $plugin_dir = basename(dirname(__FILE__)) . "/";
    //var_dump($plugin_dir);

    ob_start();
    tagpig_api_show_field($plugin_dir);
    ob_end_clean();

    $notices['no-api-key'] = trim(get_option('blogpig_api_key')) == '';
    $notices['invalid-api-key'] = !$notices['no-api-key'] && !tagpig_api_check();
    $notices['no-pro-file'] = !file_exists(ABSPATH . "wp-content/plugins/{$plugin_dir}tagpig_pro.php");
    $notices['no-ioncube'] = !extension_loaded('ionCube Loader');
    $notices['no-pro-features'] = !$notices['invalid-api-key'] && (!function_exists('tagpig_pro_api_check()') || !tagpig_pro_api_check(true));
    //var_dump($notices);

    @include(ABSPATH . "/wp-content/plugins/{$plugin_dir}tooltips.php");
    //var_dump($faqs);

    if($faqs) {
      foreach($notices as $name => $value) {
        if($value && $faqs[$name]) {
          echo '<div id="login_error" class="updated" style="padding:6px; border: solid 1px #c00; background-color: #ffebe8; ">' .
               '  <strong>TagPiG</strong> ' .
               '  ' . $faqs[$name]['message'] .
               '  ' . ($faqs[$name]['url'] ? 'Click <STRONG><a href="' . $faqs[$name]['url'] . '" target="_blank">HERE</a></STRONG> for more information.' : '') .
               '</div>';
        }
      }
    }

    return $result;
  }
  add_action('admin_notices', 'tagpig_show_notices');
}

// The old notice code...
/*
if(!function_exists('tagpig_api_show_error')) {
  function tagpig_api_show_error() {
    $result = false;

    $api_check_result = tagpig_api_check();
    if(!$api_check_result) {
      echo '<div id="login_error" class="updated" style="padding:6px; border: solid 1px #c00; background-color: #ffebe8; ">' .
           '<strong>TagPiG Stopped :: Invalid BlogPiG API Key.</strong> Get your free key <strong><a href="http://www.blogpig.com/api_key" target="_blank">HERE</a></strong>.' .
           '</div>';
    }

    return $result;
  }
  add_action('admin_notices', 'tagpig_api_show_error');
}
*/

?>