<?php
/*
* Callback functions
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/feed_generator.php');

/*
$args = array
(
'postID' => 'The id of the post which trigger this session',
'url' => 'The page url which was fetched just before this callback function is called.',
'html' => 'The page content which was fetched just before this callback function is called.'
'feed_name' => 'The feed name of the post be dumped'
);
*/

function wtg_callback_rss_feed_url($args) {
	extract($args);
	$wtg_option = get_option('wtg_option');
	return  wtg_detect_site_name() . '/' . $wtg_option['feedDir'] . '/' . $feed_name;
	//	return  get_option('siteurl') . '/' . FEED_DIR . $feed_name;
}

function wtg_callback_rss_feed_tags($args) {
	extract($args);
	$tagnames = array();
	$tags = wp_get_post_tags( $postID );
	if ( !empty( $tags ) ) {
		foreach ( $tags as $tag )
		$tagnames[] = $tag->name;
		$tagnames = implode( ', ', $tagnames );  // top1
	} else {
		$post = get_post($postID);
		$tagnames = $post->post_title;
	}
	return $tagnames;
}

function wtg_callback_FeedAgg_id_number($args) {
	extract($args);
	$pattern = '|Enter This Number: (\d{4})</td>|';
	if (preg_match($pattern, $html, $result)) {
		return $result[1];
	}
	return false;
}

function wtg_callback_rss_feed_title($args) {
	extract($args);
	$post = get_post($postID);
	return $post->post_title;
}

/**
 * return a random number between $args['extra_args'][0] and $args['extra_args'][1]
 *
 * @param unknown_type $args
 */
function wtg_callback_rss_random_number($args) {
	extract($args);
	if (empty($extra_args) || count($extra_args) < 2) 
		return 0;
	return rand($extra_args[0], $extra_args[1]);
}

function wtg_callback_rss_feed_description($args) {
	extract($args);
	$post = get_post($postID);
	/* // too long
	$p = '/((?:\S+\s+){1,100})/s';
	if (preg_match($p, (string)$post->post_content, $result)) {
		return $result[1];
	} else {
		return false;
	}
	*/
	return substr(ent2ncr(trim(strip_tags(preg_replace('|[\r\n]|', '<br/>', $post->post_content)))), 0, 100);
}
