<?php
/*
* Captcha class
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2010-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/php5_functions.php');
require_once(dirname(__FILE__) . '/simplexml.php');


if(!class_exists('WTG_Captcha')):

class WTG_Captcha {
	
	var $dom;
	var $simple_xml;
	var $captchas;

	function initDB(){
		global $wpdb;
		$table_name_captcha = $wpdb->prefix . "_wtg_captcha_services";
		$this->captchas = $wpdb->get_results( "SELECT * FROM ".$table_name_captcha." ORDER BY `name` ASC " );
	}
	
	function get_all_captchasDB() {
		return $this->captchas;
	}
	
	function get_captchaDB($id) {
		foreach ($this->get_all_captchasDB() as $captcha) {
			if (strcmp($captcha->id, $id) == 0) {
				return $captcha;
			}
		}
		return false;
	}
	
	function get_enabled_captchaDB() {
		foreach ($this->get_all_captchasDB() as $captcha) {
			if ($captcha->status == 'enabled') {
				return $captcha;
			}
		}
		return false;
	}
	
	function reverse_statusDB($id) {
		global $wpdb;
		$table_name_captcha = $wpdb->prefix . "_wtg_captcha_services";
		foreach ($this->get_all_captchasDB() as $captcha) {
			if (($captcha->id == $id) && ($captcha->status == 'disabled')) {
				$status = 'enabled';
				$this->captcha->status = 'enabled';
			} else {
				$status = 'disabled';
				$this->captcha->status = 'disabled';
			}
			$wpdb->update( $table_name_captcha , array( 'status' => $status ), array( 'id' => $captcha->id ));
		}
		return;
	}
	
	function set_captcha_paramsDB($id, $name,$user,$pwd,$key) {
		global $wpdb;
		foreach ($this->get_all_captchasDB() as $k => $captcha) {
			if ($captcha->id == $id) {
				$captcha->name = trim($name);
				$captcha->user = trim($user);
				$captcha->password = trim($pwd);
				$captcha->key = trim($key);
				
				$table_name_captcha = $wpdb->prefix . "_wtg_captcha_services";
				
				$wpdb->update( $table_name_captcha , array( 'name' => trim($name), 'user' => trim($user), 'password' => trim($pwd), 'key' => trim($key) ), array( 'id' => $id ));
				return;
				//return $this->_update();
			}
		}
		return false;
	}
	
	function get_captcha_services_enabledDB() {
		$captcha_services_enabled=0;
		foreach ($this->get_all_captchasDB() as $captcha) {
			
			if((($captcha->user != "") && ($captcha->password != "")) || ($captcha->key != "")) {
				$captcha_services_enabled = 1;
				break;
			}
		}
		return $captcha_services_enabled;
	}
	
	/*function init() {
		$captcha_xml = file_get_contents(CAPTCHA_XML_TEMPLATE);
		if (empty($captcha_xml)) return false;
		$quotes = array( 
		   '&#8216;' => "'", 
		   '&#8217;' => "'", 
		   '&#8220;' => '"', 
		   '&#8221;' => '"' 
		);
		$captcha_xml=str_replace(array_keys($quotes), $quotes, $captcha_xml);
		$captcha_xml=stripcslashes($captcha_xml);

		$this->dom = $this->_parse_captcha_xml($captcha_xml);

		return true;
	}
	
	

	function get_all_captchas() {
		return wtg_to_array($this->dom['captcha']);
	}

	function get_xml() {
		return file_get_contents(CAPTCHA_XML_TEMPLATE);
	}
	
	

	function get_captcha($id) {
		foreach ($this->get_all_captchas() as $captcha) {
			if (strcmp($captcha['id'], $id) == 0) {
				return $captcha;
			}
		}
		return false;
	}
	
	
	
	function get_enabled_captcha() {
		foreach ($this->get_all_captchas() as $captcha) {
			if ($captcha['status'] == 'enabled') {
				return $captcha;
			}
		}
		return false;
	}
	
	
	
	function reverse_status($id) {
		$captchas = &$this->dom['captcha'];
		foreach ($captchas as $k => $captcha) {
			if ($captcha['id'] == $id && $captcha['status'] == 'disabled') {
				$this->dom['captcha'][$k]['status'] = 'enabled';
			} else {
				$this->dom['captcha'][$k]['status'] = 'disabled';
			}
		}
		return $this->_update();
	}

	function _update() {
		$captcha_xml = $this->simple_xml->asXML($this->dom);
		return file_put_contents(CAPTCHA_XML_TEMPLATE, $captcha_xml);
	}

	function _parse_captcha_xml($captcha_xml) {
		$this->simple_xml = new MySimpleXML();
		return $this->simple_xml->xml_load_string($captcha_xml, 'array');
	}

	function add_captcha($name,$user,$pwd,$key) {
		//$id = strtoupper(substr(md5(strval(time())), 0, 5));
		$id = strtoupper(substr(md5(uniqid(time())), 0, 5));
		$captcha = array();
		$captcha['id'] = $id;
		$captcha['name'] = trim($name);
		$captcha['user']= trim($user);
		$captcha['password']= trim($pwd);
		$captcha['key']= trim($key);
		$this->dom['captcha'][] = $captcha;
		return $this->_update() ? $id : false;
	}

	function set_captcha_name($id, $name) {
		foreach (wtg_to_array($this->dom['captcha']) as $k => $captcha) {
			if ($captcha['id'] == $id) {
				$this->dom['captcha'][$k]['name'] = trim($name);
				return $this->_update();
			}
		}
		return false;
	}
	
	
	
	
	function set_captcha_params($id, $name,$user,$pwd,$key) {
		foreach (wtg_to_array($this->dom['captcha']) as $k => $captcha) {
			if ($captcha['id'] == $id) {
				$this->dom['captcha'][$k]['name'] = trim($name);
                $this->dom['captcha'][$k]['user'] = trim($user);
				$this->dom['captcha'][$k]['password'] = trim($pwd);
				$this->dom['captcha'][$k]['key'] = trim($key);
				return $this->_update();
			}
		}
		return false;
	}
	
	function get_captcha_services_enabled() {
		$captcha_services_enabled=0;
		foreach ($this->get_all_captchas() as $captcha) {
			if(($captcha['user'] && $captcha['password']) || $captcha['key']) {
				$captcha_services_enabled=1;
				break;
			}
		}
		return $captcha_services_enabled;
	}*/
	
	
	
}

endif;