<?php
/*
* RSS Feed List
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/other_functions.php');
wtg_db_check_and_create();
wtg_messages();

function wtg_display_rss_feed_list() 
{
	?>
		<div class="wrap">
			<h2>RSS Feed List</h2>
			<p>This screen is just for dump the feeds in order of newest to oldest.</p>
			<table width="100%">
				<tr>
					<td>
						<form action="" method="post">
							<p class="submit">
								<input type="submit" name="displayfeed" value="Show RSS Feed List &raquo;" />
							</p>
						</form>
					</td>
					<td align="right">
						<form action="" method="post">
							<p class="submit">
								<input type="submit" name="exportRssfeed" value="Export RSS Feed List &raquo;" />
							</p>
						</form>
					</td>
				</tr>
			</table>
			<?php
				if (isset($_POST['displayfeed']) || isset($_POST['exportRssfeed'])) 
				{
					$wtg_option = get_option('wtg_option');
					if (empty($wtg_option['feedDir']))
						return false;
					$feed_absdir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/';
					
					$handle = opendir($feed_absdir);
					# Making an array containing the files in the current directory:
					while ($file = readdir($handle))
					{   
					   if( $file != ".." && $file != "." )
					   {
							$file_path=$feed_absdir.$file;
							if(file_exists($file_path))
							{
								$key = filemtime($file_path);
								$files[$key] = $file;
							}
						}
					}
					
					if(isset($files)) 
					{
						krsort($files);
					}
				}
				if (isset($_POST['displayfeed'])) 
				{
					echo '<table class="widefat">
					<thead>
					<tr>
						<th>S. No.</th>
						<th>Feed Url</th>
					</tr>
					</thead>';
					$count=0;
					if(isset($files)) {
						foreach($files as $file){
							if (basename($file) != "wtg_cron_job_not_complete.lock"){
								$count++;
								echo '<tr><td>'.$count.'</td><td><a href="/'.$wtg_option['feedDir'].'/' . basename($file) . '" target="read">' . basename($file) . '</a></td></tr>';
							}
						}
					}
					
					if(empty($count)) {
						echo '<tr><td colspan="2" class="error">Sorry! There are no RSS feed.</td></tr>';
					}
					echo '</table><div><br></div>';
				} elseif (isset($_POST['exportRssfeed'])) 
				{
					$url=parse_url($_SERVER["HTTP_REFERER"]);
					if(isset($files)) 
					{
						foreach($files as $file)
						{
							$count++;
							$exportRssfeedList.=$url['scheme'].'://'.$url['host'].'/' . $wtg_option['feedDir'] . '/' . basename($file)."\n";
						}
					}
				
					if($count > 25) 
					{
						$count=25;
					}
					
					if(isset($exportRssfeedList)) 
					{
						echo '<table><tr><td><textarea wrap="off" rows="'.$count.'" cols="90" name="rssfeedlist" onclick="this.focus(); this.select();" align="center">'.$exportRssfeedList.'</textarea></td></tr></table>';
					} else {
						echo '<div class="error"><p>Sorry! There are no RSS feed.</p></div>';
					}
				}
			?>
		</div>
	<?php
}
?>