<?php 
/*
Plugin Name: Admin Management Xtended
Version: 2.1.5
Plugin URI: http://www.schloebe.de/wordpress/admin-management-xtended-plugin/
Description: <strong>WordPress 2.7+ only.</strong> Extends admin functionalities by introducing: toggling post/page visibility inline, changing page order with drag'n'drop, inline category management, inline tag management, changing publication date inline, changing post slug inline, toggling comment status open/closed, hide draft posts, change media order, change media description inline, toggling link visibility, changing link categories
Author: Oliver Schl&ouml;be
Author URI: http://www.schloebe.de/


Copyright 2008-2010 Oliver Schlöbe (email : scripts@schloebe.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * The main plugin file
 *
 * @package WordPress_Plugins
 * @subpackage AdminManagementXtended
 */

/**
 * Pre-2.6 compatibility
 */
if ( !defined( 'WP_CONTENT_URL' ) )
	define( 'WP_CONTENT_URL', get_option( 'siteurl' ) . '/wp-content' );
if ( !defined( 'WP_CONTENT_DIR' ) )
	define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
if ( !defined( 'WP_PLUGIN_URL' ) )
	define( 'WP_PLUGIN_URL', WP_CONTENT_URL. '/plugins' );
if ( !defined( 'WP_PLUGIN_DIR' ) )
	define( 'WP_PLUGIN_DIR', WP_CONTENT_DIR . '/plugins' );



/**
 * Checks if a given plugin is active
 *
 * @since 1.4.0
 * @author scripts@schloebe.de
 *
 * @param string
 * @return bool
 */
function ame_is_plugin_active( $plugin_filename ) {
	$plugins = get_option('active_plugins');
	if( !is_array($plugins) ) settype($plugins, 'array');
	return ( in_array($plugin_filename, $plugins) );
}

/**
 * Define the plugin version
 */
define("AME_VERSION", "2.1.5");

/**
 * Define the global var AMEISWP25, returning bool if at least WP 2.5 is running
 */
define('AMEISWP25', version_compare($GLOBALS['wp_version'], '2.4.999', '>'));

/**
 * Define the global var AMEISWP27, returning bool if WP 2.7 or higher is running
 */
define('AMEISWP27', version_compare($GLOBALS['wp_version'], '2.6.999', '>'));

/**
 * Define the global var ISINSTBTM, returning bool
 * if the 'Better Tags Manager' plugin is installed
 */
define('ISINSTBTM', ame_is_plugin_active('better-tags-manager/better-tags-manager.php') );

/**
 * Define the plugin path slug
 */
define("AME_PLUGINPATH", "/" . plugin_basename( basename( dirname(__FILE__) ) ) . "/");

/**
 * Define the plugin full url
 */
define("AME_PLUGINFULLURL", WP_PLUGIN_URL . AME_PLUGINPATH );

/**
 * Define the plugin full directory
 */
define("AME_PLUGINFULLDIR", WP_PLUGIN_DIR . AME_PLUGINPATH );

/**
 * Define the plugin image set
 */
define("AME_IMGSET", get_option("ame_imgset") . "/" );


/** 
* The AdminManagementXtended class
*
* @package WordPress_Plugins
* @subpackage AdminManagementXtended
* @since 1.4.0
* @author scripts@schloebe.de
*/
class AdminManagementXtended {

	/**
 	* The AdminManagementXtended class constructor
 	* initializing required stuff for the plugin
 	*
 	* @since 1.4.0
 	* @author scripts@schloebe.de
 	*/
	function adminmanagementxtended() {	
		
		if( ISINSTBTM ) {
			add_action('admin_notices', array(&$this, 'wpBTMIncompCheck'));
		}
		
		if ( !AMEISWP27 ) {
			add_action('admin_notices', array(&$this, 'wpVersion27Failed'));
			return;
		}
		add_action('init', array(&$this, 'ame_load_textdomain'));
		
		/** 
 		* This file holds all of the general information and functions
 		*/
		require_once(AME_PLUGINFULLDIR . 'general-functions.php');

		/** 
 		* This file holds all of the post functions
 		*/
		require_once(AME_PLUGINFULLDIR . 'post-functions.php');

		/** 
 		* This file holds all of the page functions
 		*/
		require_once(AME_PLUGINFULLDIR . 'page-functions.php');

		/** 
 		* This file holds all of the media functions
 		*/
		require_once(AME_PLUGINFULLDIR . 'media-functions.php');

		/** 
 		* This file holds all of the link functions
 		*/
		require_once(AME_PLUGINFULLDIR . 'link-functions.php');
		
		if( !get_option("ame_show_orderoptions") ) {
			add_option("ame_show_orderoptions", "1");
		}
		if( !get_option("ame_toggle_showinvisposts") ) {
			add_option("ame_toggle_showinvisposts", "1");
		}
		if( !get_option("ame_version") ) {
			add_option("ame_version", AME_VERSION);
		}
		if( !get_option("ame_imgset") ) {
			add_option("ame_imgset", 'set1');
		}
		if( get_option("ame_version") != AME_VERSION ) {
			update_option("ame_version", AME_VERSION);
		}
	}


	/**
	 * Fires several actions, depending on type
	 *
	 * @since 1.8.6
	 * @author scripts@schloebe.de
	 */
	function fireActions( $type, $catid, $post ) {
		switch( $type ) {
			case "post":
				do_action('edit_post', $catid, $post);
				//do_action('save_post', $catid, $post); // Causing problems... well.
				do_action('wp_insert_post', $catid, $post);
				return $post;
		}
	}
	
	/**
 	* Initialize and load the plugin textdomain
 	*
 	* @since 1.8.5
 	* @author scripts@schloebe.de
 	*/
	function ame_load_textdomain() {
		if ( function_exists('load_plugin_textdomain') ) {
			if ( !defined('WP_PLUGIN_DIR') ) {
       		 	load_plugin_textdomain('admin-management-xtended', str_replace( ABSPATH, '', dirname(__FILE__) ) . '/languages');
        	} else {
        		load_plugin_textdomain('admin-management-xtended', false, dirname(plugin_basename(__FILE__)) . '/languages');
        	}
		}
	}
	
	/**
 	* Checks for the version of WordPress,
 	* and adds a message to inform the user
 	* if required WP version is less than 2.5
 	*
 	* @since 1.4.0
	* @deprecated Deprecated since version 2.0
	* @see wpVersion27Failed()
 	* @author scripts@schloebe.de
 	*/
	function wpVersionFailed() {
		echo "<div id='wpversionfailedmessage' class='error fade'><p>" . __('Admin Management Xtended requires at least WordPress 2.5!', 'admin-management-xtended') . "</p></div>";
	}
	
	/**
 	* Checks for the version of WordPress,
 	* and adds a message to inform the user
 	* if WP version is >= 2.7 which isnt supported
 	*
 	* @since 2.0
 	* @author scripts@schloebe.de
 	*/
	function wpVersion27Failed() {
		echo "<div id='wpversion27failedmessage' class='error fade'><p>" . sprintf(__("<strong>Admin Management Xtended</strong> plugin version 2.0 requires at least WordPress 2.7! If you're still using a WP version prior to 2.7, please <a href='%s'>use Admin Management Xtended version 1.9.1</a>! Consider updating to the latest WP version for your own safety!", 'admin-management-xtended'), 'http://downloads.wordpress.org/plugin/admin-management-xtended.1.9.1.zip') . "</p></div>";
	}
	
	/**
 	* Checks for the existance of 'Better Tags Manager' plugin,
 	* which is known to cause problems with this plugin
 	* and adds a message to inform the user
 	*
 	* @since 1.4.0
 	* @author scripts@schloebe.de
 	*/
	function wpBTMIncompCheck() {
		echo "<div id='wpbtmincompmessage' class='error fade'><p>" . __("You seem using the <em>Better Tags Manager</em> plugin, which collides with the <em>Admin Management Xtended</em> plugin since both extend the tags column. Please deactivate one of both to make this message disappear.", 'admin-management-xtended') . "</p><p align='right' style='font-weight:200;'><small><em>" . __('(This message was created by Admin Management Xtended plugin)', 'admin-management-xtended') . "</em></small></p></div>";
	}
	
}

if ( class_exists('AdminManagementXtended') ) {
	$adminmanagementxtended = new AdminManagementXtended();
}
?>