<?php
class indexing_tool_admin {

	function indexing_tool_admin() {
		add_action('admin_menu', array(&$this, 'admin_menu'));
	}

	function admin_menu() {
		$pluginpage = add_options_page('Indexing Tool Settings', 'Indexing Tool', 'manage_options', __FILE__, array(&$this, 'settings_page'));
		add_action("admin_print_scripts-$pluginpage", array(&$this, 'admin_head'));
	}// end func

	function admin_head() {
		wp_enqueue_script('jquery');
		wp_enqueue_script('loadjs', WP_PLUGIN_URL.'/indexing-tool/admin.js');
		echo '<link rel="stylesheet" href="'.WP_PLUGIN_URL.'/indexing-tool/admin.css" type="text/css" />'."\n";
	}// end func

	function settings_page() {
		
		global $indexing_tool;
		$options = $indexing_tool->get_options();
		$pages = get_pages();
		
		if ( isset($_POST['update']) ) {
			
			// check user is authorised
			if ( function_exists('current_user_can') && !current_user_can('manage_options') )
				die('Sorry, not allowed...');
			check_admin_referer('indexing_tool_settings');

			$url = trim($_POST['feedurl']);
			if ( $url != $options['feedurl'] ) {
				unset($options['urls']);
				unset($options['indexed_urls']);
				if ( '' != $url ) {
					$rss = fetch_feed($url);
					if ( !is_wp_error($rss) ) {
						if ( $rss->get_item_quantity() ) {
							foreach ( $rss->get_items() as $item ) {
								$link = str_replace('&amp;', '&', $item->get_link());
								$title = str_replace('&amp;', '&', $item->get_title());
								$options['urls'][$link]['title'] = $title;
								$options['urls'][$link]['status'] = 'unchecked';
							}// end foreach
						} else {
							$msg .= '<p>Error: No items found in RSS feed.</p>';
						}// end if
					} else {
						$msg .= '<p>Error: '.$rss->get_error_message().'<p>';
					}// end if
					unset($rss);
				}// end if
				$options['feedurl'] = $url;
			}// end if

			/*
			if ( $_POST['clearcache'] == true) {
				unset($options['urls']);
				unset($options['indexed_urls']);
			}// end if
			*/

			$options['title'] = trim($_POST['title']);
			$options['max_links'] = intval($_POST['max_links']);
			//isset($_POST['show_on_posts']) ? $options['show_on_posts'] = true : $options['show_on_posts'] = false;
			$options['show_on_posts'] = ( isset($_POST['show_on_posts']) ) ? true : false;

			if ( is_array($_POST['linkspages']) )
				$options['linkspages'] = $_POST['linkspages'];
			else
				$options['linkspages'] = array();

			$options['new_window'] = ( isset($_POST['new_window']) ) ? true : false;

			$options['delay'] = intval($_POST['delay']);
			isset($_POST['debug']) ? $options['debug'] = true : $options['debug'] = false;

			isset($_POST['remove_settings']) ? $options['remove_settings'] = true : $options['remove_settings'] = false;

			update_option('indexing_tool', $options);

			$msg .= '<p><strong>Settings saved.</strong></p>';
			echo '<div id="message" class="updated fade">'.$msg.'</div>';
		
		}// end if

		echo '<div class="wrap">'
			.'<h2>'.$indexing_tool->name.' Settings - version '.$indexing_tool->version.'</h2>'
			.'<form method="post">';
		wp_nonce_field('indexing_tool_settings');
		echo '<table class="form-table">'
			.'<tr>'
				.'<th scope="row">Full RSS feed URL:</th>'
				.'<td><span class="description">The full URL of the RSS feed containing the links you want to check (clear this box and save changes to start again).</span><br /><input type="text" name="feedurl" id="feedurl" value="'.stripslashes($options['feedurl']).'" class="regular-text" style="width:98%" /></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Title for the list of links:</th>'
				.'<td><input type="text" name="title" id="title" value="'.stripslashes($options['title']).'" class="regular-text" style="width:98%" /></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Maximum links to display:</th>'
				.'<td><input type="text" name="max_links" id="max_links" value="'.$options['max_links'].'" class="small-text" /> <span class="description">The maximum number of links to display after your content.</span></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Show links on posts:</th>'
				.'<td><input type="checkbox" id="show_on_posts" name="show_on_posts"';
		if ( $options['show_on_posts'] ) echo 'checked="checked"';
		echo ' /> <span class="description">Tick this box to show links after your posts.</span></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Show links on pages:</th>'
				.'<td><div style="padding-top:0.2em;"><span class="description"><a href="javascript:void(0);" id="linkspages">Click here to choose pages</a></span></div>'
				.'<div id="linkspages-inside" style="display:none;">';
				$linkspages = $options['linkspages'];
				foreach ($pages as $page) {
					echo '<input type="checkbox" name="linkspages[]" value="'.$page->ID.'"';
					if ( in_array($page->ID, $linkspages) )
						echo ' checked="checked"';
					echo ' /> '.$page->post_title.'<br />';
				}
				echo '</div></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Open links in new window:</th>'
				.'<td><input type="checkbox" id="new_window" name="new_window"';
		if ( $options['new_window'] ) echo 'checked="checked"';
		echo ' /> <span class="description">Tick this box to open links in a new window.</span></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Delay between checks:</th>'
				.'<td><select name="delay" id="delay" style="width:100px;">';
					if ( $options['debug'] ) {
						echo '<option value="10"';
						if ( $options['delay'] == '10' ) echo " selected='selected'";
						echo ">10 seconds</option>";
					}// end if
					echo '<option value="600"';
					if ( $options['delay'] == '600' ) echo " selected='selected'";
					echo ">10 minutes</option>"
					.'<option value="1800"';
					if ( $options['delay'] == '1800' ) echo " selected='selected'";
					echo ">30 minutes</option>"
					.'<option value="3600"';
					if ( $options['delay'] == '3600' ) echo " selected='selected'";
					echo ">1 hour</option>"
					.'<option value="10800"';
					if ( $options['delay'] == '10800' ) echo " selected='selected'";
					echo ">3 hours</option>"
					.'<option value="43200"';
					if ( $options['delay'] == '43200' ) echo " selected='selected'";
					echo ">12 hours</option>"
					.'</select> <span class="description">Minimum delay between checks.</span></td>'
			.'</tr>'
			.'<tr>'
				.'<th scope="row">Debug mode:</th>'
				.'<td><input type="checkbox" id="debug" name="debug"';
				if ( $options['debug'] ) echo 'checked="checked"';
				echo ' /> <span class="description">Tick this box to enable debug mode (information will be added as HTML comments on pages).</span></td>'
			.'</tr>'
			.'</table>'
			.'<p class="submit"><input type="submit" name="update" class="button-primary" value="Save Changes" /></p>'
			.'<!--p style="font-size:11px;"><input type="checkbox" id="remove_settings" name="remove_settings"';
		if ( $options['remove_settings'] ) echo 'checked="checked"';
		echo ' /> Tick this box if you are going to deactivate the plugin and you want to delete the settings.</p-->'
			.'<h3><span>Your Link Status</span></h3>'
			.'<div class="unchecked">= Waiting to be checked</div>'
			.'<div class="unindexed">= Has not been indexed</div>'
			.'<div class="indexed">= Has been indexed</div>'
			.'<div class="banned">= Not enough delay between checks</div></p>'
			.'<p class="status"><span>Not Checked or Not Indexed</span> (these links can be displayed on your blog)</p>'
			.'<ul class="rss-indexer">';
			if ( is_array($options['urls']) && count($options['urls']) ) {
				foreach ( $options['urls'] as $url => $stats ) {
					echo '<li class="'.$stats['status'].'"><a href="'.stripslashes($url).'" target="_blank">'.$stats['title'].'</a>';
					if ( '' != $stats['lastchecked'] )
						echo ' (checked: '.date('d M Y, g:i a', $stats['lastchecked']).')';
					echo '</li>';
				}// end foreach
			} else {
				echo '<li>No links available.</li>';
			}// end if
			echo '</ul>'
			.'<p class="status"><span>Indexed</span> (these links will not be displayed on your blog)</h4>'
			.'<ul class="rss-indexer">';
			if ( is_array($options['indexed_urls']) && count($options['indexed_urls']) ) {
				foreach ( $options['indexed_urls'] as $url => $stats ) {
					echo '<li class="'.$stats['status'].'"><a href="'.stripslashes($url).'" target="_blank">'.$stats['title'].'</a></li>';
				}// end foreach
			} else {
				echo '<li>No links available.</li>';
			}// end if
		echo '</ul>'
			.'</form>'
			.'</div>';
		
	}// end function

}// end class
$indexing_tool_admin = new indexing_tool_admin;
